<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Entities;

use Core\Model\Entities\TIdUnsigned;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Table(name: 'eshop_catalog__package_item')]
#[ORM\Entity]
class PackageItem
{
	use TIdUnsigned;

	#[ORM\JoinColumn(name: 'package_id', referencedColumnName: 'id', nullable: false, onDelete: 'CASCADE')]
	#[ORM\ManyToOne(targetEntity: Package::class, cascade: ['persist'])]
	protected Package $package;

	#[ORM\JoinColumn(name: 'product_id', referencedColumnName: 'id', nullable: false, onDelete: 'CASCADE')]
	#[ORM\ManyToOne(targetEntity: Product::class)]
	protected Product $product;

	#[ORM\Column(type: Types::INTEGER, nullable: false, options: ['default' => 1, 'unsigned' => true])]
	public int $quantity = 1;

	public function __construct(
		Package $package,
		Product $product
	)
	{
		$this->package = $package;
		$this->product = $product;
	}

	public function getPackage(): Package { return $this->package; }

	public function getProduct(): Product { return $this->product; }
}
