<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Entities;

use DateTimeInterface;
use Core\Model\Entities\TIdUnsigned;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;
use Nette\Utils\DateTime;

#[ORM\Table(name: 'eshop_catalog__product_change_plan')]
#[ORM\Entity]
class ProductChangePlan
{
	public const columnVatRate = 'vatRate';

	use TIdUnsigned;

	#[ORM\JoinColumn(referencedColumnName: 'id', onDelete: 'CASCADE')]
	#[ORM\ManyToOne(targetEntity: Product::class)]
	protected Product $product;

	#[ORM\Column(name: '`column`', type: Types::STRING, length: 255)]
	protected string $column;

	#[ORM\Column(name: '`value`', type: Types::STRING, length: 255)]
	protected string $value;

	#[ORM\Column(type: Types::DATETIME_MUTABLE)]
	protected DateTimeInterface $created;

	#[ORM\Column(type: Types::DATETIME_MUTABLE)]
	protected DateTimeInterface $changeAt;

	#[ORM\Column(type: Types::DATETIME_MUTABLE, nullable: true)]
	protected ?DateTimeInterface $changed = null;

	public function __construct(
		Product            $product,
		string             $column,
		string             $value,
		DateTimeInterface $changeAt
	)
	{
		$this->product  = $product;
		$this->column   = $column;
		$this->value    = $value;
		$this->created  = new DateTime();
		$this->changeAt = $changeAt;
	}

	public function getColumn(): string { return $this->column; }

	public function getValue(): string { return $this->value; }

	public function getCreated(): DateTimeInterface { return $this->created; }

	public function getChangeAt(): DateTimeInterface { return $this->changeAt; }

	public function getChanged(): ?DateTimeInterface { return $this->changed; }

	public function getProduct(): Product { return $this->product; }

	public function change(): void
	{
		$this->changed = new DateTime();
	}
}
