<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Entities;

use Core\Model\Entities\TId;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;
use EshopCatalog\Model\Helpers\DocumentsHelper;

#[ORM\Table(name: 'eshop_catalog__product_document')]
#[ORM\Entity]
class ProductDocument
{
	use TId;

	#[ORM\JoinColumn(referencedColumnName: 'id', nullable: false, onDelete: 'CASCADE')]
	#[ORM\ManyToOne(targetEntity: Product::class)]
	public Product $product;

	#[ORM\Column(type: Types::STRING, length: 2, nullable: true)]
	public ?string $lang = null;

	#[ORM\Column(type: Types::STRING, nullable: false)]
	public string $name;

	#[ORM\Column(type: Types::STRING, nullable: false)]
	public string $file;

	public function __construct(?string $lang, string $name, string $file, Product $product)
	{
		$this->lang    = $lang;
		$this->name    = $name;
		$this->file    = $file;
		$this->product = $product;
	}

	public function isSecured(): bool { return DocumentsHelper::isSecured($this->file); }

	public function getFullPath(): string { return DocumentsHelper::getFullPath($this->file); }

}
