<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Entities;

use Core\Model\Entities\Site;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Table(name: 'eshop_catalog__product_in_site')]
#[ORM\Index(columns: ['product_id', 'site', 'is_active'], name: 'catalog_search')]
#[ORM\Entity]
#[ORM\EntityListeners([ProductInSiteListener::class])]
class ProductInSite
{
	#[ORM\JoinColumn(name: 'product_id', referencedColumnName: 'id', nullable: false, onDelete: 'CASCADE')]
	#[ORM\Id]
	#[ORM\ManyToOne(targetEntity: Product::class)]
	protected Product $product;

	#[ORM\JoinColumn(name: 'site', referencedColumnName: 'ident', nullable: false, onDelete: 'CASCADE')]
	#[ORM\Id]
	#[ORM\ManyToOne(targetEntity: Site::class)]
	protected Site $site;

	#[ORM\Column(type: Types::SMALLINT, nullable: false, options: ['default' => 0])]
	protected int $isActive = 0;

	#[ORM\JoinColumn(name: 'category_id', referencedColumnName: 'id', nullable: true, onDelete: 'SET NULL')]
	#[ORM\ManyToOne(targetEntity: Category::class)]
	public ?Category $category = null;

	public function __construct(Product $product, Site $site)
	{
		$this->product  = $product;
		$this->site     = $site;
		$this->isActive = 0;
	}

	public function getProduct(): Product { return $this->product; }

	public function getSite(): Site { return $this->site; }

	/**
	 * @return bool|int
	 */
	public function isActive() { return $this->isActive; }

	public function setActive(int $active = 1): self
	{
		$this->isActive = $active;

		return $this;
	}

}
