<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Entities;

use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;
use EshopOrders\Model\Entities\Payment;

#[ORM\Table(name: 'eshop_catalog__product_payment')]
#[ORM\Entity]
class ProductPayment
{
	#[ORM\JoinColumn(name: 'product_id', referencedColumnName: 'id', nullable: false, onDelete: 'CASCADE')]
	#[ORM\Id]
	#[ORM\ManyToOne(targetEntity: Product::class, inversedBy: 'payments')]
	public Product $product;

	#[ORM\JoinColumn(name: 'payment_id', referencedColumnName: 'id', nullable: false, onDelete: 'CASCADE')]
	#[ORM\Id]
	#[ORM\ManyToOne(targetEntity: Payment::class)]
	public Payment $payment;

	#[ORM\Column(name: 'payment_disabled', type: Types::SMALLINT, length: 1, options: ['default' => 0])]
	public int $paymentDisabled = 0;

	public function __construct(Product $product, Payment $payment)
	{
		$this->product = $product;
		$this->payment = $payment;
	}

}
