<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Entities;

use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;
use EshopOrders\Model\Entities\GroupCustomers;

#[ORM\Table(name: 'eshop_catalog__product_price_level')]
#[ORM\Entity]
class ProductPriceLevel
{
	#[ORM\JoinColumn(name: 'product_id', referencedColumnName: 'id', onDelete: 'CASCADE')]
	#[ORM\Id]
	#[ORM\ManyToOne(targetEntity: Product::class, cascade: ['persist', 'remove'], inversedBy: 'priceLevels')]
	private Product $productId;

	#[ORM\JoinColumn(name: 'group_id', referencedColumnName: 'id', onDelete: 'CASCADE')]
	#[ORM\Id]
	#[ORM\ManyToOne(targetEntity: GroupCustomers::class)]
	private GroupCustomers $groupId;

	/**
	 * @var double
	 */
	#[ORM\Column(type: Types::DECIMAL, precision: 10, scale: 2)]
	public $price;

	public function __construct(Product $productId, GroupCustomers $groupId)
	{
		$this->productId = $productId;
		$this->groupId   = $groupId;
	}

	public function getGroupId(): GroupCustomers { return $this->groupId; }

}
