<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Entities;

use DateTimeInterface;
use Doctrine\ORM\Mapping as ORM;
use Nette\Utils\DateTime;

/**
 * @ORM\Table(name="eshop_catalog__product_replenishment_plan")
 * @ORM\Entity
 */
class ProductReplenishmentPlan
{
	/**
	 * @ORM\Id
	 * @ORM\ManyToOne(targetEntity="Product")
	 * @ORM\JoinColumn(name="product_id", referencedColumnName="id", nullable=false, onDelete="CASCADE")
	 */
	public Product $product;

	/**
	 * @ORM\Column(type="datetime", nullable=true)
	 */
	public ?DateTimeInterface $lastUpdate = null;

	/**
	 * @ORM\Column(type="integer", nullable=false)
	 */
	public int $recommendedQuantity;

	/**
	 * @ORM\Column(type="json", nullable=true)
	 */
	public ?array $salesStatistics = null;

	public function __construct(Product $product, int $recommendedQuantity)
	{
		$this->product             = $product;
		$this->recommendedQuantity = $recommendedQuantity;
		$this->lastUpdate          = new DateTime;
	}

}