<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Entities;

use Core\Model\Entities\TIdUnsigned;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Table(name: 'eshop_catalog__product_supplier_skip')]
#[ORM\Entity]
class ProductSupplierSkip
{
	use TIdUnsigned;

	#[ORM\Column(type: Types::STRING, length: 255, nullable: false)]
	public string $code;

	#[ORM\JoinColumn(name: 'id_supplier', referencedColumnName: 'id', onDelete: 'CASCADE')]
	#[ORM\ManyToOne(targetEntity: Supplier::class)]
	public Supplier $supplier;

	public function __construct(string $code, Supplier $supplier)
	{
		$this->code     = $code;
		$this->supplier = $supplier;
	}
}
