<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Entities;

use DateTime;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Table(name: 'eshop_catalog__product_tag')]
#[ORM\Index(columns: ['valid_from', 'valid_to'], name: 'valid_idx')]
#[ORM\Entity]
class ProductTag
{
	#[ORM\JoinColumn(name: 'id_product', referencedColumnName: 'id', onDelete: 'CASCADE')]
	#[ORM\Id]
	#[ORM\ManyToOne(targetEntity: Product::class, cascade: ['persist'], inversedBy: 'ProductTags')]
	private Product $product;

	#[ORM\JoinColumn(name: 'id_tag', referencedColumnName: 'id', onDelete: 'CASCADE')]
	#[ORM\Id]
	#[ORM\ManyToOne(targetEntity: Tag::class)]
	private Tag $tag;

	#[ORM\Column(type: Types::DATETIME_MUTABLE, nullable: true)]
	public ?DateTime $validFrom = null;

	#[ORM\Column(type: Types::DATETIME_MUTABLE, nullable: true)]
	public ?DateTime $validTo = null;

	public function __construct(Product $product, Tag $tag)
	{
		$this->product = $product;
		$this->tag     = $tag;
	}

	public function setProduct(Product $product): self
	{
		$this->product = $product;

		return $this;
	}

	public function getProduct(): Product
	{
		return $this->product;
	}

	public function getTag(): Tag
	{
		return $this->tag;
	}

}
