<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Entities;

use Core\Model\Entities\TId;
use Core\Model\Entities\TranslateListener;
use Core\Model\Entities\TTranslateListener;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;

#[ORM\Table(name: 'eshop_catalog__related_group')]
#[ORM\Entity]
#[ORM\EntityListeners([TranslateListener::class])]
class RelatedGroup
{
	use TId;
	use TTranslateListener;

	#[ORM\Column(type: Types::SMALLINT, options: ['default' => 1])]
	public int $isPublished = 1;

	/** @Gedmo\SortablePosition */
	#[ORM\Column(type: Types::INTEGER)]
	protected int $position = -1;

	/** @var Collection<string, RelatedGroupText> */
	#[ORM\OneToMany(mappedBy: 'group', targetEntity: RelatedGroupText::class, cascade: ['persist', 'remove'], indexBy: 'lang')]
	protected Collection $texts;

	public function __construct()
	{
		$this->texts = new ArrayCollection;

		$this->setPosition(-1);
	}

	public function getPosition(): int { return $this->position; }

	public function setPosition(int $position): self
	{
		$this->position = $position;

		return $this;
	}

	public function getText(?string $lang = null): ?RelatedGroupText
	{
		return $this->texts[$lang ?: $this->locale];
	}

	/**
	 * @return Collection<string, RelatedGroupText>
	 */
	public function getTexts(): Collection { return $this->texts; }

	/**
	 * @param RelatedGroupText[] $texts
	 */
	public function setTexts(array $texts): self
	{
		$this->texts = new ArrayCollection($texts);

		return $this;
	}

}
