<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Entities;

use Core\Model\Entities\TId;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Table(name: 'eshop_catalog__related_product')]
#[ORM\Entity]
class RelatedProduct
{
	use TId;

	#[ORM\JoinColumn(name: 'origin_id', referencedColumnName: 'id', nullable: false, onDelete: 'CASCADE')]
	#[ORM\ManyToOne(targetEntity: Product::class, inversedBy: 'relatedProducts')]
	protected Product $origin;

	#[ORM\JoinColumn(name: 'product_id', referencedColumnName: 'id', nullable: false, onDelete: 'CASCADE')]
	#[ORM\ManyToOne(targetEntity: Product::class)]
	protected Product $product;

	#[ORM\JoinColumn(name: 'group_id', referencedColumnName: 'id', nullable: false, onDelete: 'CASCADE')]
	#[ORM\ManyToOne(targetEntity: RelatedGroup::class)]
	protected RelatedGroup $group;

	public function __construct(Product $origin, Product $product, RelatedGroup $group)
	{
		$this->origin  = $origin;
		$this->product = $product;
		$this->group   = $group;
	}

	public function getOrigin(): Product { return $this->origin; }

	public function getProduct(): Product { return $this->product; }

	public function getGroup(): RelatedGroup { return $this->group; }

	public function setGroup(RelatedGroup $group): void { $this->group = $group; }

	public function setOrigin(Product $origin): void { $this->origin = $origin; }

}
