<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Entities;

use DateTime;
use Core\Model\Entities\Site;
use Core\Model\Entities\TIdUnsigned;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Table(name: 'eshop_catalog__search_history')]
#[ORM\Entity]
class SearchHistory
{
	use TIdUnsigned;

	#[ORM\Column(type: Types::STRING, length: 255, nullable: false)]
	public string $text;

	#[ORM\Column(type: Types::DATETIME_MUTABLE, nullable: false)]
	public DateTime $createdAt;

	#[ORM\JoinColumn(name: 'site_id', referencedColumnName: 'ident', nullable: false, onDelete: 'CASCADE')]
	#[ORM\ManyToOne(targetEntity: Site::class)]
	public Site $site;

	#[ORM\Column(type: Types::INTEGER, nullable: false, options: ['default' => 0, 'unsigned' => true])]
	public int $views = 0;

	public function __construct(
		Site   $site,
		string $text
	)
	{
		$this->site      = $site;
		$this->text      = $text;
		$this->createdAt = new DateTime();
	}
}
