<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Entities;

use Core\Model\Entities\Site;
use Core\Model\Entities\TId;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Table(name: 'eshop_catalog__seller_in_site')]
#[ORM\Entity]
class SellerInSite
{
	use TId;

	#[ORM\JoinColumn(name: 'seller_id', referencedColumnName: 'id', nullable: false, onDelete: 'CASCADE')]
	#[ORM\ManyToOne(targetEntity: Seller::class, inversedBy: 'sites')]
	private Seller $seller;

	#[ORM\JoinColumn(name: 'site_id', referencedColumnName: 'ident', nullable: false, onDelete: 'CASCADE')]
	#[ORM\ManyToOne(targetEntity: Site::class)]
	private Site $site;

	#[ORM\Column(name: 'in_stock', type: Types::SMALLINT, length: 1, options: ['default' => 1])]
	public int $isActive;

	public function __construct(Seller $seller, Site $site)
	{
		$this->seller   = $seller;
		$this->site     = $site;
		$this->isActive = 1;
	}

	public function getSeller(): Seller { return $this->seller; }

	public function getSite(): Site { return $this->site; }

}
