<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Entities;

use Core\Model\Entities\TId;
use Core\Model\Entities\TranslateListener;
use Core\Model\Entities\TTranslateListener;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Table(name: 'eshop_catalog__supplier')]
#[ORM\Entity]
#[ORM\EntityListeners([TranslateListener::class])]
class Supplier
{
	use TId;
	use TTranslateListener;

	#[ORM\Column(type: Types::STRING, nullable: false)]
	public string $name;

	#[ORM\Column(type: Types::STRING, length: 255, nullable: true)]
	public ?string $logo = null;

	#[ORM\Column(type: Types::SMALLINT, length: 1)]
	public int $isPublished = 0;

	#[ORM\Column(type: Types::SMALLINT, length: 1, options: ['default' => 1])]
	public int $allowSale = 1;

	#[ORM\Column(type: Types::STRING, length: 255, nullable: true)]
	public ?string $website = null;

	/** @var Collection<string, SupplierTexts> */
	#[ORM\OneToMany(mappedBy: 'id', targetEntity: SupplierTexts::class, cascade: ['all'], indexBy: 'lang')]
	protected Collection $supplierTexts;

	/** @var Collection<string, ProductSupplier> */
	#[ORM\OneToMany(mappedBy: 'supplier', targetEntity: ProductSupplier::class, cascade: ['persist', 'remove'], orphanRemoval: true)]
	protected Collection $products;

	public function __construct(string $name)
	{
		$this->name          = $name;
		$this->products      = new ArrayCollection;
		$this->supplierTexts = new ArrayCollection;
		$this->isPublished   = 0;
	}

	public function addSupplierText(string $lang): void
	{
		$this->supplierTexts->set($lang, new SupplierTexts($this, $lang));
	}

	public function setSupplierText(SupplierTexts $supplierTexts): void
	{
		$this->supplierTexts->set($supplierTexts->getLang(), $supplierTexts);
	}

	public function getSupplierText(?string $lang = null): ?SupplierTexts
	{
		return $this->supplierTexts->get($lang ?: $this->locale);
	}

}
