<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Entities;

use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Table(name: 'eshop_catalog__supplier_texts')]
#[ORM\Entity]
class SupplierTexts
{
	#[ORM\JoinColumn(name: 'id', referencedColumnName: 'id', onDelete: 'CASCADE')]
	#[ORM\Id]
	#[ORM\ManyToOne(targetEntity: Supplier::class, cascade: ['persist', 'remove'], inversedBy: 'SupplierTexts')]
	private Supplier $id;

	#[ORM\Id]
	#[ORM\Column(type: Types::STRING, length: 2)]
	private string $lang;

	#[ORM\Column(type: Types::TEXT, nullable: true)]
	public ?string $description = null;

	public function __construct(Supplier $id, string $lang)
	{
		$this->id   = $id;
		$this->lang = $lang;
	}

	public function getLang(): string
	{
		return $this->lang;
	}

}
