<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Entities;

use Core\Model\Entities\TId;
use Core\Model\Entities\TranslateListener;
use Core\Model\Entities\TTranslateListener;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Table(name: 'eshop_catalog__tag')]
#[ORM\Entity]
#[ORM\EntityListeners([TranslateListener::class])]
class Tag
{
	use TId;
	use TTranslateListener;

	#[ORM\Column(type: Types::STRING)]
	public string $type;

	/** @var Collection<string, TagText> */
	#[ORM\OneToMany(targetEntity: TagText::class, mappedBy: 'tag', cascade: ['all'], indexBy: 'lang')]
	protected Collection $texts;

	#[ORM\Column(type: Types::STRING, length: 255, nullable: true)]
	public ?string $image = null;

	#[ORM\Column(type: Types::STRING, nullable: true)]
	public ?string $color = null;

	#[ORM\Column(type: Types::STRING, nullable: true)]
	public ?string $bgColor = null;

	#[ORM\Column(type: Types::SMALLINT, nullable: true, options: ['unsigned' => true])]
	public ?int $ppcPriority = null;

	#[ORM\Column(type: Types::SMALLINT, nullable: false, options: ['unsigned' => true, 'default' => 0])]
	public int $hideProductTagName = 0;

	public function __construct()
	{
		$this->texts = new ArrayCollection;
	}

	public function setText(TagText $tagText): void
	{
		$this->texts->set($tagText->getLang(), $tagText);
	}

	public function setTexts(array $tagTexts): self
	{
		$this->texts = new ArrayCollection($tagTexts);

		return $this;
	}

	public function getText(?string $lang = null): ?TagText
	{
		return $this->texts->get($lang ?: $this->locale);
	}

	/**
	 * @return Collection<string, TagText>
	 */
	public function getTexts(): Collection { return $this->texts; }

}
