<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Entities;

use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Table(name: 'eshop_catalog__tag_texts')]
#[ORM\Entity]
class TagText
{
	#[ORM\JoinColumn(name: 'tag', referencedColumnName: 'id', onDelete: 'CASCADE')]
	#[ORM\Id]
	#[ORM\ManyToOne(targetEntity: Tag::class, cascade: ['persist', 'remove'], inversedBy: 'texts')]
	private Tag $tag;

	#[ORM\Id]
	#[ORM\Column(type: Types::STRING, length: 2)]
	private string $lang;

	#[ORM\Column(type: Types::STRING, length: 255, nullable: true)]
	public ?string $name = null;

	#[ORM\Column(type: Types::STRING, length: 255, nullable: true)]
	public ?string $description = null;

	public function __construct(Tag $tag, string $lang)
	{
		$this->tag  = $tag;
		$this->lang = $lang;
	}

	public function getLang(): string
	{
		return $this->lang;
	}

}
