<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Event;

use Symfony\Contracts\EventDispatcher\Event;

class ProductsFeedEvent extends Event
{
	public ?string $lang      = null;
	public ?string $siteIdent = null;

	public function __construct(
		public array   &$data,
		public ?string $customerName,
		public string  $outputFormat = 'json',
	)
	{
	}
}
