<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Helpers;

use Core\Model\Dao\Site;
use Core\Model\Settings;
use Core\Model\Sites;
use Users\Model\Entities\User;

class Helper
{
	public function __construct(
		protected Settings $settings,
		protected Sites    $sites,
	)
	{
	}

	public function getRegisterUserSale(User $user, ?Site $site = null): float
	{
		if (!$site instanceof Site) {
			$site = $this->sites->getCurrentSite();
		}

		$disabledRegisterUserSale = (array) $this->settings->get('eshopCatalogDisableRegisterUserSaleForRole', []);
		foreach ($user->getRolesId() as $roleId) {
			if (in_array($roleId, $disabledRegisterUserSale)) {
				return 0;
			}
		}

		return (float) $this->settings->get('eshopCatalog' . ucfirst($site->getIdent()) . 'RegisterUserSale', 0);
	}

}
