<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Helpers;

use EshopCatalog\Model\Config;
use EshopCatalog\Model\IProductsOldUrlResolver;
use Nette\DI\Container;

class ProductsHelper
{
	public function __construct(
		protected Container $container,
	)
	{
	}

	public function getOldUrlResolver(): ?IProductsOldUrlResolver
	{
		$resolver = $this->container->getByType(IProductsOldUrlResolver::class, false);

		return $resolver ?: null;
	}

	public static function processPrice(float $price, int $vat): float
	{
		return round($price * (($vat / 100) + 1), 2);
	}

	public static function getPriceWithoutVat(float $price, int $vat): float
	{
		return round(($price / (($vat / 100) + 1)), 2);
	}

	public static function filterGroupVariantsInList(array $products, array $variants): array
	{
		if (!Config::load('groupVariantsInList', false)) {
			return $products;
		}

		$tmp          = [];
		$usedVariants = [];

		foreach ($products as $id) {
			$v = $variants[$id] ?? null;

			if (!$v) {
				$tmp[$id] = $id;
			} else if (!isset($usedVariants[$v['variantId']])) {
				$tmp[$id]                      = $id;
				$usedVariants[$v['variantId']] = $id;
			} else if ($v['isDefault'] === 1) {
				$tmp[$usedVariants[$v['variantId']]] = $id;
			}
		}

		return array_values($tmp);
	}
}
