<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Listeners;

use Doctrine;
use Doctrine\ORM\Mapping as ORM;
use Doctrine\Persistence\Event\LifecycleEventArgs;
use EshopCatalog\FrontModule\Model\CacheService;
use EshopCatalog\Model\Entities\ProductPriceCountryHistory;
use Override;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

class ProductPriceCountryHistoryListener implements EventSubscriberInterface
{
	public function __construct(
		protected CacheService $cacheService,
	)
	{
	}

	#[Override]
	public static function getSubscribedEvents(): array
	{
		return [];
	}

	#[ORM\PostPersist]
	public function onPostPersist(ProductPriceCountryHistory $entity, LifecycleEventArgs $args): void
	{
		$this->cacheService->priceCache->remove('retailPriceCountry/' . $entity->country->getId() . '/' . $entity->product->getId());
	}

}
