<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Navigation;

use Core\Components\Navigation\DaoNavigationItem;
use Core\Model\UI\Form\BaseContainer;
use Core\Model\UI\Form\BaseForm;
use Navigations\Model\Event\RouteOutEvent;
use Navigations\Model\Providers\INavigationItem;
use Nette\Caching\Cache;
use Nette\Utils\ArrayHash;
use Override;
use Pages\AdminModule\Model\TemplatePages;

class Search extends BaseNavigation implements INavigationItem
{
	protected $title     = 'search';
	protected $presenter = 'EshopCatalog:Front:Default';
	protected $action    = 'search';

	public const CACHE_SEARCH = 'eshopCatalogSearch';

	public function __construct(
		protected TemplatePages $templatePagesService,
	)
	{
	}

	/**
	 * @inheritDoc
	 */
	#[Override]
	public function getFormContainer(BaseForm $baseForm): BaseContainer
	{
		$container = new BaseContainer;
		$site      = $baseForm->getCustomData('loadComponent')['site'];
		$pages     = $this->templatePagesService->getOptionsForSelectGrouped();
		$pages     = (array) ($pages[$site ?? $baseForm->getComponent('site')->getValue()] ?? $pages);

		$container->addSelect('templateResult', 'eshopCatalog.navigationBuilder.templateResult', $pages);

		return $container;
	}

	#[Override]
	public function formSuccess(BaseForm $form, ArrayHash $values)
	{
	}

	#[Override]
	public function updateCacheDep(array &$cache, $urlParams)
	{
		$cache[Cache::TAGS][] = self::CACHE_SEARCH . '/' . $urlParams['q'];

		parent::updateCacheDep($cache, $urlParams);
	}

	/*******************************************************************************************************************
	 * ===========================  Route
	 */

	#[Override]
	public function presenterActionCheck($presenter, $action)
	{
		return $this->presenter == $presenter && $this->action == $action;
	}

	/**
	 * @param DaoNavigationItem $navigation
	 * @param array             $urlParams
	 */
	#[Override]
	public function routerIn($navigation, $urlParams = []): array
	{
		$return = [
			'presenter' => $this->presenter,
			'action'    => $this->action,
		];

		$parts = explode('/', (string) $urlParams['path']);

		if (isset($parts[1])) {
			$return['q'] = $parts[1];
		} else if (isset($urlParams['q'])) {
			$return['q'] = $urlParams['q'];
		}

		return $return;
	}

	#[Override]
	public function routerOut(DaoNavigationItem $navigation, &$urlParams): ?string
	{
		if (isset($urlParams['do']) && str_contains((string) $urlParams['do'], 'searchForm')) {
			unset($urlParams['do']);
		}

		$url = ($navigation->isHomepage ? '' : '/' . $navigation->alias);

		$this->eventDispatcher->dispatch(new RouteOutEvent($urlParams, $navigation, $url), BaseNavigation::class . '::routeOut');

		return $url;
	}
}
