<?php declare(strict_types = 1);

namespace EshopCatalog\Model;

class NavigationFilter
{
	public function processRouterOut(array $urlParams): array
	{
		unset($urlParams['productsFilter-filter']['f']);
		$tmp               = [];
		$filtrName         = 'productsFilter';
		$filtrValSeparator = '|';

		if (isset($urlParams['do']) && $urlParams['do'] == $filtrName . '-set') {
			$type  = substr((string) $urlParams[$filtrName . '-t'], 0, 1);
			$key   = $urlParams[$filtrName . '-k'];
			$value = $urlParams[$filtrName . '-v'];
			$skip  = null;

			foreach ($urlParams[$filtrName . '-filter']['f' . $type] as $k => $current) {
				if (is_string($current)) {
					foreach (explode($filtrValSeparator, $current) as $v) {
						if ($v == $value) {
							$skip = $value;
						} else if ($v) {
							$tmp[$type][$k][] = $v;
						}
					}
				}
			}

			if ($value && $value != $skip) {
				$tmp[$type][$key][] = $value;
			}

			if ($value == null) {
				unset($tmp[$type][$key]);
			}

			unset($urlParams[$filtrName . '-filter']['f' . $type]);
			unset($urlParams[$filtrName . '-t']);
			unset($urlParams[$filtrName . '-k']);
			unset($urlParams[$filtrName . '-v']);

			foreach ($tmp as $type => $groups) {
				foreach ($groups as $group => $vals) {
					/** @phpstan-ignore-next-line */
					if ($vals === []) {
						continue;
					}
					$urlParams[$filtrName . '-filter']['f' . $type][$group] = implode($filtrValSeparator, $vals);
				}
			}
		}

		return $urlParams;
	}

}
