<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Subscribers;

use Core\Model\Event\TemplateFactoryEvent;
use Core\Model\Sites;
use EshopCatalog\FrontModule\Model\Sellers;
use Override;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

class TemplateFactorySubscriber implements EventSubscriberInterface
{
	public function __construct(
		protected Sellers $sellersService,
		protected Sites   $sites,
	)
	{
	}

	#[Override]
	public static function getSubscribedEvents(): array
	{
		return [
			'templateFactory::createTemplate' => 'createTemplate',
		];
	}

	public function createTemplate(TemplateFactoryEvent $event): void
	{
		$event->template->seller        = $this->sellersService->getSellerForSite($this->sites->getCurrentSite()->getIdent());
		$event->template->blocksFiles[] = SRC_DIR . '/eshopcatalog/src/FrontModule/Templates/blocks.latte';
	}

}
