CKEDITOR.dialog.add('eshopcatalogproduct', function (editor) {
	const PRODUCTS_URL = '/cron/eshop-catalog/products/load-all';
	const lang         = editor.lang.eshopcatalogproduct;

	// Vytvoření řádku v obsahu editoru
	function createContent(product) {
		return `<div data-id="${product.id}">${product.code1} - ${product.manufacturer} ${product.name}</div>`;
	}

	function createRow(product, idx) {
		return `<tr data-id="${product.id}" data-idx="${idx}">
			        <td class="w1nw">${product.code1}</td>
			        <td>${product.name}</td>
			        <td class="ck-editor-table__col-action">
			            ${CKEDITOR.pshkUtils.createXButton().outerHTML}
			            ${CKEDITOR.pshkUtils.createMoveButton().outerHTML}
			        </td>
		        </tr>`;
	}

	function toBase64Unicode(str) {
		return btoa(unescape(encodeURIComponent(str)));
	}

	function fromBase64Unicode(str) {
		return decodeURIComponent(escape(atob(str)));
	}

	return {
		title    : lang.selectProducts,
		minWidth : 400,
		minHeight: 200,
		contents : [
			{
				id      : 'main',
				elements: [
					{
						type: 'html',
						id  : 'datafields',
						html: `
							<div class="cke_dialog_ui_row">
								<div class="cke_dialog_ui_text ck-editor-input-wrap">
									<label class="cke_dialog_ui_labeled_label">${lang.search}</label>
									<div class="cke_dialog_ui_labeled_content">
										<div class="cke_dialog_ui_input_text">
											<input class="cke_dialog_ui_input_text" type="text"
											data-autocomplete-name="ckEditorEshopCatalogProduct"
											data-autocomplete-keys="id,code1,code2,ean,name"
											data-autocomplete-url="${PRODUCTS_URL}"
											id="ckEditorEshopCatalogProduct"
											autocomplete="off">
										</div>
									</div>
								</div>
								
								<div class="ck-editor-table-wrap">
		                            <table id="selected-products" class="ck-editor-table">
		                                <thead>
		                                    <tr>
		                                        <th>${lang.code}</th>
		                                        <th>${lang.name}</th>
		                                        <th class="ck-editor-table__col-action">${lang.action}</th>
		                                    </tr>
		                                </thead>
		                                <tbody></tbody>
		                            </table>
	                            </div>
                            </div>
                            
							<div class="cke_dialog_ui_row">
	                            <div class="ck-editor-dialog__footer-info">
	                                <p>${lang.footerInfo}</p>
	                            </div>
                            </div>
                        `
					}
				]
			}
		],
		onShow   : function () {
			const dialog             = this;
			const input              = document.getElementById('ckEditorEshopCatalogProduct');
			const tableBody          = document.querySelector('#selected-products tbody');
			dialog._selectedProducts = [];

			input.focus();

			function bindTableEvents() {
				tableBody.querySelectorAll('.ck-editor-btn--remove').forEach(btn => {
					btn.addEventListener('click', function (e) {
						const row                = e.target.closest('tr');
						const id                 = row.getAttribute('data-id');
						dialog._selectedProducts = dialog._selectedProducts.filter(p => p.id.toString() !== id);
						renderTable();
					});
				});
			}

			function renderTable() {
				tableBody.innerHTML = dialog._selectedProducts.map((p, i) => createRow(p, i)).join('');
				bindTableEvents();
				initSortable();
			}

			let sortableInstance = null;

			function initSortable() {
				if (sortableInstance) {
					sortableInstance.destroy();
				}
				sortableInstance = Sortable.create(tableBody, {
					handle   : '.drag-handle',
					animation: 150,
					onEnd    : function (evt) {
						// Přeskládej selectedProducts podle nového pořadí řádků
						const newOrder = [];
						tableBody.querySelectorAll('tr').forEach(tr => {
							const pid   = tr.getAttribute('data-id');
							const found = dialog._selectedProducts.find(p => p.id.toString() === pid);
							if (found) {
								newOrder.push(found);
							}
						});

						dialog._selectedProducts = newOrder;
					}
				});
			}

			this._autocompleteHandler = function (e) {
				if (e.detail.name === 'ckEditorEshopCatalogProduct') {
					dialog._selectedProducts.push(e.detail.selection.value);
					renderTable();
					input.value = '';
				}
			};

			document.addEventListener('autocompleteOnSelection', this._autocompleteHandler);

			dialog.setupContent = function (widget) {
				input.focus();

				const dataAttr = widget.element.getAttribute('data-products');
				if (dataAttr) {
					dialog._selectedProducts = JSON.parse(fromBase64Unicode(dataAttr));
					renderTable();
				} else {
					dialog._selectedProducts = [];
					tableBody.innerHTML      = '';
				}
			};

			dialog.commitContent = function (widget) {
				widget.element.setAttribute('data-products', toBase64Unicode(JSON.stringify(dialog._selectedProducts)));

				widget.element.$.innerHTML = dialog._selectedProducts.map(createContent).join('');

				dialog._selectedProducts = [];
				tableBody.innerHTML      = '';
			};
		},
		onHide   : function () {
			if (this._autocompleteHandler) {
				document.removeEventListener('autocompleteOnSelection', this._autocompleteHandler);
				delete this._autocompleteHandler;
			}
		}
	};
});
