CKEDITOR.plugins.add('eshopcatalogproduct', {
	requires: ['widget', 'pshkutils'],
	icons   : 'eshopcatalogproduct',
	lang    : 'cs',
	init    : function(editor) {
		const lang = editor.lang.eshopcatalogproduct;

		editor.addContentsCss(this.path + 'css/eshopcatalogproducts.css');

		CKEDITOR.dialog.add('eshopcatalogproduct', this.path + 'dialogs/eshopcatalogproduct.js');
		editor.widgets.add('EshopCatalogProduct', {
			requiredContent: 'div(eshopcatalogproduct)',
			template       : '<div class="eshopcatalogproduct" data-title="' + lang.title + '"></div>',
			button         : lang.title,
			dialog         : 'eshopcatalogproduct',
			upcast         : function(element) {
				return element.name == 'div' && element.hasClass('eshopcatalogproduct');
			},
			init           : function() {
				if (this.element.hasAttribute('data-id'))
					this.setData('id', this.element.getAttribute('data-id'));
			},
			data           : function() {
				this.element.setAttribute('data-id', this.data.id);
			}
		});
	}
});
