CKEDITOR.dialog.add('eshopcatalogproductfromcat', function(editor) {
	const CATEGORIES_URL    = '/cron/eshop-catalog/categories/categories';
	const FEATURES_URL      = '/cron/eshop-catalog/features/feature-value';
	const MANUFACTURERS_URL = '/cron/eshop-catalog/manufacturers/manufacturers';
	const lang              = editor.lang.eshopcatalogproductfromcat;

	function createContentCategory(category) {
		return `<div data-id="${category.id}">${category.id} - ${category.name}</div>`;
	}

	function createContentManufacturer(manu) {
		return `<div data-id="${manu.id}">${manu.id} - ${manu.name}</div>`;
	}

	function createRowCategory(product, idx) {
		return `<tr data-id="${product.id}" data-idx="${idx}">
			        <td class="w1nw">${product.id}</td>
			        <td>${product.name}</td>
			        <td class="ck-editor-table__col-action">
			            ${CKEDITOR.pshkUtils.createXButton().outerHTML}
			        </td>
		        </tr>`;
	}

	function createRowManufacturer(manu, idx) {
		return `<tr data-id="${manu.id}" data-idx="${idx}">
			        <td class="w1nw">${manu.id}</td>
			        <td>${manu.name}</td>
			        <td class="ck-editor-table__col-action">
			            ${CKEDITOR.pshkUtils.createXButton().outerHTML}
			        </td>
		        </tr>`;
	}

	function toBase64Unicode(str) {
		return btoa(unescape(encodeURIComponent(str)));
	}

	function fromBase64Unicode(str) {
		return decodeURIComponent(escape(atob(str)));
	}

	return {
		title    : lang.selectCategoriesAndProduct,
		minWidth : 400,
		minHeight: 200,
		contents : [
			{
				id      : 'main',
				elements: [
					{
						type: 'html',
						id  : 'datafields',
						html: `
							<div class="cke_dialog_ui_row">
								<div class="cke_dialog_ui_text ck-editor-input-wrap">
									<label class="cke_dialog_ui_labeled_label">${lang.limit}</label>
									<div class="cke_dialog_ui_labeled_content">
										${CKEDITOR.pshkUtils.createInput('', this._limit, 'number', '', 'limit-input', 'ckEditorEshopCatalogProductFromCatLimit').outerHTML}
									</div>
								</div>
							</div>
								
							<div class="cke_dialog_ui_row">
								<div class="cke_dialog_ui_text ck-editor-input-wrap">
									<label class="cke_dialog_ui_labeled_label">${lang.searchCategory}</label>
									<div class="cke_dialog_ui_labeled_content">
										<div class="cke_dialog_ui_input_text">
											<input class="cke_dialog_ui_input_text" type="text"
											data-autocomplete-name="ckEditorEshopCatalogProductFromCat"
											data-autocomplete-keys="id,name"
											data-autocomplete-url="${CATEGORIES_URL}"
											id="ckEditorEshopCatalogProductFromCat"
											autocomplete="off">
										</div>
									</div>
								</div>
							
								<div class="ck-editor-table-wrap">
									<label class="ck-editor-table-description">${lang.categoriesTableText}</label>
		                            <table id="selected-categories" class="ck-editor-table">
		                                <thead>
		                                    <tr>
		                                        <th>${lang.id}</th>
		                                        <th>${lang.name}</th>
		                                        <th class="ck-editor-table__col-action">${lang.action}</th>
		                                    </tr>
		                                </thead>
		                                <tbody></tbody>
		                            </table>
								</div>
							</div>
								
							<div class="cke_dialog_ui_row">
								<div class="cke_dialog_ui_text ck-editor-input-wrap">
									<label class="cke_dialog_ui_labeled_label">${lang.searchManufacturer}</label>
									<div class="cke_dialog_ui_labeled_content">
										<div class="cke_dialog_ui_input_text">
											<input class="cke_dialog_ui_input_text" type="text"
											data-autocomplete-name="ckEditorEshopCatalogProductFromCatManufacturer"
											data-autocomplete-keys="id,name"
											data-autocomplete-url="${MANUFACTURERS_URL}"
											id="ckEditorEshopCatalogProductFromCatManufacturer"
											autocomplete="off">
										</div>
									</div>
								</div>
								
								<div class="ck-editor-table-wrap">
									<label class="ck-editor-table-description">${lang.manufacturersTableText}</label>
		                            <table id="selected-manufacturers" class="ck-editor-table">
		                                <thead>
		                                    <tr>
		                                        <th>${lang.id}</th>
		                                        <th>${lang.name}</th>
		                                        <th class="ck-editor-table__col-action">${lang.action}</th>
		                                    </tr>
		                                </thead>
		                                <tbody></tbody>
		                            </table>
								</div>
							</div>
		
							<div class="cke_dialog_ui_row">
								<label class="cke_dialog_ui_labeled_label">${lang.features}</label>
								<div id="filter-builder"></div>
							</div>
	                            
							<div class="cke_dialog_ui_row">
	                            <div class="ck-editor-dialog__footer-info">
	                                <p>${lang.footerInfo}</p>
	                            </div>
							</div>
                        `
					}
				]
			}
		],
		onShow   : function() {
			const dialog                  = this;
			const inputSearchCategory     = document.getElementById('ckEditorEshopCatalogProductFromCat');
			const tableBodyCategories     = document.querySelector('#selected-categories tbody');
			const inputSearchManufacturer = document.getElementById('ckEditorEshopCatalogProductFromCatManufacturer');
			const tableBodyManufacturers  = document.querySelector('#selected-manufacturers tbody');
			const limitInput              = document.getElementById('ckEditorEshopCatalogProductFromCatLimit');

			function initVariables() {
				dialog._selectedCategories    = [];
				dialog._selectedManufacturers = [];
				dialog._limit                 = 3;
			}

			initVariables();

			inputSearchCategory.focus();

			function bindTableEvents() {
				tableBodyCategories.querySelectorAll('.ck-editor-btn--remove').forEach(btn => {
					btn.addEventListener('click', function(e) {
						const row                  = e.target.closest('tr');
						const id                   = row.getAttribute('data-id');
						dialog._selectedCategories = dialog._selectedCategories.filter(p => p.id.toString() !== id);
						renderTableCategories();
					});
				});

				tableBodyManufacturers.querySelectorAll('.ck-editor-btn--remove').forEach(btn => {
					btn.addEventListener('click', function(e) {
						const row                     = e.target.closest('tr');
						const id                      = row.getAttribute('data-id');
						dialog._selectedManufacturers = dialog._selectedManufacturers.filter(p => p.id.toString() !== id);
						renderTableManufacturers();
					});
				});

				limitInput.oninput = function() {
					dialog._limit = parseInt(limitInput.value);
				};
			}

			function renderTableCategories() {
				tableBodyCategories.innerHTML = dialog._selectedCategories.map((p, i) => createRowCategory(p, i)).join('');
				bindTableEvents();
			}

			function renderTableManufacturers() {
				tableBodyManufacturers.innerHTML = dialog._selectedManufacturers.map((p, i) => createRowManufacturer(p, i)).join('');
				bindTableEvents();
			}

			this._autocompleteHandler = function(e) {
				if (e.detail.name === 'ckEditorEshopCatalogProductFromCat') {
					dialog._selectedCategories.push(e.detail.selection.value);
					renderTableCategories();
					inputSearchCategory.value = '';
				} else if (e.detail.name === 'ckEditorEshopCatalogProductFromCatManufacturer') {
					dialog._selectedManufacturers.push(e.detail.selection.value);
					renderTableManufacturers();
					inputSearchManufacturer.value = '';
				} else if (e.detail.name.startsWith('ckEditorEshopCatalogProductFromCat')) {
					const input = document.getElementById(e.detail.inputId);

					if (input) {
						if (input.onAutocomplete) {
							input.onAutocomplete(e.detail.selection.value);
						}
					}
				}
			};

			document.addEventListener('autocompleteOnSelection', this._autocompleteHandler);

			let rootGroup;

			const groupElementsMap = new Map();

			function createEmptyGroup() {
				return {
					id      : generateId(),
					op      : 'AND',
					children: []
				};
			}

			function generateIdAutocomplete() {
				return 'Autocomplete-' + Date.now() + '-' + Math.floor(Math.random() * 100000);
			}

			function generateId() {
				return 'group-cond-' + Date.now() + '-' + Math.floor(Math.random() * 100000);
			}

			function renderConditionAuto(condition, group, idx, parentGroup, renderGroupCallback) {
				const condDiv            = document.createElement('div');
				condDiv.className        = 'condition';
				condDiv.style.display    = 'flex';
				condDiv.style.alignItems = 'center';
				condDiv.style.gap        = '8px';

				// Autocomplete input (field)
				const propertyInputId = 'ckEditorEshopCatalogProductFromCat' + generateIdAutocomplete();
				const propertyInput   = CKEDITOR.pshkUtils.createInput(null, condition.field || '', 'text', '', 'autocomplete-property', propertyInputId);
				propertyInput.setAttribute('autocomplete', 'off');
				propertyInput.setAttribute('data-autocomplete-name', propertyInputId);
				propertyInput.setAttribute('data-autocomplete-keys', 'id,name');
				propertyInput.setAttribute('data-autocomplete-url', FEATURES_URL);

				propertyInput.onAutocomplete = (detail) => {
					propertyInput.value = detail.name;

					condition.field = detail.name;
					condition.value = detail.id;

					const valueInput = document.getElementById(propertyInputId + '-value');
					if (valueInput) {
						valueInput.value = detail.id;
					}
				};

				// Hodnota (value)
				const valueInput = CKEDITOR.pshkUtils.createInput(null, condition.value || '', 'text', '', 'condition-value', propertyInputId + '-value');
				valueInput.setAttribute('disabled', 'disabled');

				const removeBtn = CKEDITOR.pshkUtils.createXButton(() => {
					group.children.splice(idx, 1);
					renderGroupCallback(group, parentGroup);
					if (condDiv.onremove) {
						condDiv.onremove();
					}
				});

				// Operátor - select
				const operators      = ['=', '!='];
				const operatorSelect = CKEDITOR.pshkUtils.createSelect('', operators, '=', 'condition-operator', '', true);
				if (!condition.operator) {
					condition.operator = '=';
				}
				operatorSelect.value = condition.operator;

				operatorSelect.onchange = () => {
					condition.operator = operatorSelect.value;
				};

				condDiv.appendChild(propertyInput);
				condDiv.appendChild(valueInput);
				condDiv.appendChild(operatorSelect);
				condDiv.appendChild(removeBtn);

				return condDiv;
			}

			function renderGroup(group, parentGroup) {
				let groupEl = groupElementsMap.get(group.id);
				if (groupEl) {
					groupEl.innerHTML = '';
				} else {
					groupEl           = document.createElement('div');
					groupEl.className = parentGroup ? 'condition-group-nested' : 'condition-group';
					groupElementsMap.set(group.id, groupEl);
					if (!parentGroup) {
						const root     = document.querySelector('#filter-builder');
						root.innerHTML = '';
						root.appendChild(groupEl);
					}
				}

				// OpRow, opSelect stejné...
				const opRow            = document.createElement('div');
				opRow.style.display    = 'flex';
				opRow.style.alignItems = 'center';
				opRow.style.gap        = '6px';

				const opSelect    = CKEDITOR.pshkUtils.createSelect('', ['AND', 'OR'], group.op, 'group-operator', '', true);
				opSelect.onchange = (e) => {
					group.op = e.target.value;
				};
				opRow.appendChild(opSelect);

				if (parentGroup) {
					const removeGroupBtn = CKEDITOR.pshkUtils.createXButton(() => {
						const idx = parentGroup.children.indexOf(group);
						if (idx !== -1) {
							parentGroup.children.splice(idx, 1);
							renderGroup(parentGroup, null);
						}
						groupElementsMap.delete(group.id);
					});

					opRow.appendChild(removeGroupBtn);
				}

				groupEl.appendChild(opRow);

				const childrenDiv     = document.createElement('div');
				childrenDiv.className = 'group-children';

				group.children.forEach((child, idx) => {
					if (child.children) {
						renderGroup(child, group);
						const nestedGroupEl = groupElementsMap.get(child.id);
						if (nestedGroupEl) childrenDiv.appendChild(nestedGroupEl);
					} else {
						childrenDiv.appendChild(
							renderConditionAuto(child, group, idx, parentGroup, renderGroup)
						);
					}
				});

				groupEl.appendChild(childrenDiv);

				const buttonsGroup = document.createElement('div');

				const addConditionBtn = CKEDITOR.pshkUtils.createTextButton(lang.addCondition, () => {
					group.children.push({field: '', value: ''});
					renderGroup(group, parentGroup);
				});
				buttonsGroup.appendChild(addConditionBtn);

				const addGroupBtn = CKEDITOR.pshkUtils.createTextButton(lang.addGroup, () => {
					const newGroup = createEmptyGroup();
					group.children.push(newGroup);
					renderGroup(group, parentGroup);
				});
				buttonsGroup.appendChild(addGroupBtn);

				groupEl.appendChild(buttonsGroup);

				return groupEl;
			}

			dialog.setupContent = function(widget) {
				inputSearchCategory.focus();
				const dataLimit = widget.element.getAttribute('data-limit');
				if (dataLimit) {
					dialog._limit    = parseInt(dataLimit);
					limitInput.value = dialog._limit;
				} else {
					dialog._limit    = 3;
					limitInput.value = dialog._limit;
				}

				const dataCategories = widget.element.getAttribute('data-categories');
				if (dataCategories) {
					dialog._selectedCategories = JSON.parse(fromBase64Unicode(dataCategories));
					renderTableCategories();
				} else {
					dialog._selectedCategories    = [];
					tableBodyCategories.innerHTML = '';
				}

				const dataManufacturers = widget.element.getAttribute('data-manufacturers');
				if (dataManufacturers) {
					dialog._selectedManufacturers = JSON.parse(fromBase64Unicode(dataManufacturers));
					renderTableManufacturers();
				} else {
					dialog._selectedManufacturers    = [];
					tableBodyManufacturers.innerHTML = '';
				}

				const dataFeatures = widget.element.getAttribute('data-features');
				if (dataFeatures) {
					rootGroup = JSON.parse(fromBase64Unicode(dataFeatures));
				} else {
					rootGroup = createEmptyGroup();
				}

				renderGroup(rootGroup, null);
			};

			dialog.commitContent = function(widget) {
				let content = [];

				content.push(`<div>${lang.limit} - ${dialog._limit}</div>`);

				if (dialog._selectedCategories.length) {
					content.push(`<div>${lang.categories}</div>` + dialog._selectedCategories.map(createContentCategory).join(''));
				}

				if (dialog._selectedManufacturers.length) {
					content.push(`<div>${lang.manufacturers}</div>` + dialog._selectedManufacturers.map(createContentManufacturer).join(''));
				}

				if (rootGroup.children.length) {
					content.push(`<div>${lang.outputWithFeatures}</div>`);
				}

				widget.element.$.innerHTML = content.join('<div style="height: 10px;">&nbsp;</div>');

				widget.element.setAttribute('data-limit', dialog._limit);
				widget.element.setAttribute('data-features', toBase64Unicode(JSON.stringify(rootGroup)));
				widget.element.setAttribute('data-categories', toBase64Unicode(JSON.stringify(dialog._selectedCategories)));
				widget.element.setAttribute('data-manufacturers', toBase64Unicode(JSON.stringify(dialog._selectedManufacturers)));

				initVariables();
				tableBodyCategories.innerHTML    = '';
				tableBodyManufacturers.innerHTML = '';
			};
		},
		onHide   : function() {
			if (this._autocompleteHandler) {
				document.removeEventListener('autocompleteOnSelection', this._autocompleteHandler);
				delete this._autocompleteHandler;
			}
		}
	};
});
