if (!global.document.autocompleteResultItem) {
	global.document.autocompleteResultItem = {};
}

global.document.autocompleteResultItem['eshopCatalogRelatedProducts'] = (data, source) => {
	let str = data.value.code1 + ' | ';

	if (data.value.manufacturer) {
		str += data.value.manufacturer + ' - ';
	}

	str += data.value.name;

	source.innerHTML = str;
};

document.addEventListener('autocompleteOnSelection', e => {
	if (e.detail.name === 'eshopCatalogRelatedProducts') {
		const relatedProductsGroupSelect = document.getElementById('relatedProductsGroupSelect');
		let id                           = e.detail.selection.value.id;
		let name                         = e.detail.selection.value.name;
		name                             = name.charAt(0).toUpperCase() + name.slice(1);

		let template = '<tr><td>' + name + '</td>' +
		               '<td>' + relatedProductsGroupSelect.innerHTML.replace('__id__', id) + '</td>' +
		               '<td class="fit-content"><a href="#" class="btn btn-danger btn-remove-related-product"><i class="fas fa-trash"></i></a></td></tr>';

		let productDuplicated = document.querySelector('select[name^="relatedProductsIds[' + id + ']"]');

		if (!productDuplicated) {
			document.querySelector('#related-products tbody').insertAdjacentHTML('beforeend', template);
		}

		e.target.value = '';
		e.target.focus();
	}
});

document.addEventListener('click', e => {
	let target = e.target;

	if (target.matches('.btn-remove-related-product')) {
		e.preventDefault();
		target.closest('tr').remove();
		return false;
	}
});
