import {Carousel} from '@fancyapps/ui'

const initProductCardHandler = () => {
	for (const el of document.querySelectorAll('.product-card > a')) {
		el.addEventListener('click', async e => {
			let id = null
			if (e.target.tagName !== 'A') {
				id = e.target.closest('a').dataset.id
			} else {
				id = e.target.dataset.id
			}

			window.disableLoader = true

			global.naja.makeRequest('post', window.personalizationAlternativeProducts.apiUrlCtr, {productId: id}, {
				history: false,
			})
		})
	}
}

const initAlternativeProductsSlider = () => {
	const sliderEl = document.getElementById('alternative-products-slider')

	if (sliderEl) {
		new Carousel(sliderEl, {
			infinite: true,
			Dots: false,
			Navigation: true,
			transition: 'slide',
			dragFree: false,
			center: false,
			breakpoints: {
				0: {
					slidesPerPage: 1
				},
				767: {
					slidesPerPage: 2
				},
				992: {
					slidesPerPage: 3
				},
				1200: {
					slidesPerPage: 4,
				}
			},
			on: {
				'init': (carousel, eventName) => {
					carousel.container.classList.add('inited')
				}
			}
		})
	}
}

document.addEventListener('DOMContentLoaded', e => {
	initProductCardHandler()
	initAlternativeProductsSlider()
})