const initBestSellingProductsListHandler = () => {
	document.addEventListener('click', e => {
		const el = e.target
		if (el.dataset.hasOwnProperty('showButton')) {
			const list = document.querySelector('#best-selling-products-list');
			const collapse = list.querySelector('.personalization-list__collapse')

			if (!collapse) {
				return
			}

			if (collapse.classList.contains('personalization-list__collapse--opened')) {
				collapse.classList.remove('personalization-list__collapse--opened');
				e.target.innerHTML = e.target.dataset.showMoreText;
			} else {
				collapse.classList.add('personalization-list__collapse--opened');
				e.target.innerHTML = e.target.dataset.showLessText;
			}
		}
	})
}

document.addEventListener('DOMContentLoaded', e => {
	initBestSellingProductsListHandler()
})