import {Carousel} from '@fancyapps/ui'

const initCrossSellProductsSlider = () => {
	const sliderEl = document.getElementById('cross-sell-products-slider')

	if (sliderEl) {
		new Carousel(sliderEl, {
			infinite: true,
			Dots: false,
			Navigation: true,
			transition: 'slide',
			dragFree: false,
			center: false,
			breakpoints: {
				0: {
					slidesPerPage: 1
				},
				767: {
					slidesPerPage: 2
				},
				992: {
					slidesPerPage: 3
				},
				1200: {
					slidesPerPage: 4,
				}
			},
			on: {
				'init': (carousel, eventName) => {
					carousel.container.classList.add('inited')
				}
			}
		})
	}
}

document.addEventListener('DOMContentLoaded', e => {
	initCrossSellProductsSlider()
})