import {Carousel, Fancybox} from '@fancyapps/ui';
import {Thumbs} from '@fancyapps/ui/dist/carousel/carousel.thumbs.esm.js';
import {slideDown, slideUp} from 'es6-slide-up-down';

Fancybox.defaults.Hash      = false;
Fancybox.defaults.trapFocus = false;

document.addEventListener('DOMContentLoaded', () => {
	/**
	 * Uvodni obrazek
	 */
	Fancybox.bind('[data-fancybox-eshop-pd="product"]', {
		groupAll: true
	});
	const baseProductSlider = document.getElementById('product-slider');
	if (baseProductSlider) {
		new Carousel(baseProductSlider, {
			infinite: true,
			Thumbs  : {
				type: 'classic'
			}
		}, {Thumbs});
	}

	/**
	 * General tabs logic
	 * [data-tabs] => triggers the target
	 * [data-tabs-content] => Defines the target
	 * [data-tabs-group] => Sets target to the switching group
	 * [data-tabs-default] => Sets default target to be visible
	 */
	const tabs = document.querySelectorAll('[data-tabs]');
	tabs.forEach(el => {
		el.addEventListener('click', () => {
			const tabTarget        = el.dataset.tabs;
			const tabsContent      = document.querySelector(`[data-tabs-content="${tabTarget}"]`);
			const tabGroup         = tabsContent.dataset.tabsGroup;
			const tabGroupElements = document.querySelectorAll(`[data-tabs-group="${tabGroup}"]`);

			tabs.forEach((tab) => tab.classList.remove('active'));
			el.classList.add('active');
			tabGroupElements.forEach(el => el.style.display = 'none');
			tabsContent.style.display = 'block';
		});
	});

	document.querySelectorAll(`[data-tabs-content]`).forEach(el => {
		el.style.display = 'none';
	});

	document.querySelectorAll('[data-tabs-default]').forEach(el => {
		const tabTarget           = el.dataset.tabs;
		const tabsContent         = document.querySelector(`[data-tabs-content="${tabTarget}"]`);
		tabsContent.style.display = 'block';
		tabsContent.classList.add('active');
		el.classList.add('active');
	});
});

document.addEventListener('click', e => {
	const target = e.target;

	const el = target.classList.contains('product-safety-warning__title');
	if (el) {
		const parent = target.closest('.product-safety-warning');

		if (parent) {
			const target = parent.querySelector('.product-safety-warning__content');

			if (target) {
				if (parent.classList.contains('active')) {
					slideUp(target);
					parent.classList.remove('active');
				} else {
					slideDown(target);
					parent.classList.add('active');
				}
			}
		}
	}
});
