<?php declare(strict_types = 1);

namespace EshopCatalog\AdminModule\Components\VatRates;

use Core\Model\UI\BaseControl;
use Core\Model\UI\Form\BaseForm;
use EshopCatalog\Model\Config;
use Exception;
use Nette\InvalidArgumentException;
use Nette\Utils\ArrayHash;
use EshopCatalog\Model\Entities\VatRate;
use EshopCatalog\AdminModule\Model\VatRates;

class VatRateForm extends BaseControl
{
	/** @var int|null @persistent */
	public ?int        $id      = null;
	protected VatRates $vatRateServices;
	public ?VatRate    $vatRate = null;

	public function __construct(
		VatRates $vatRates
	)
	{
		$this->vatRateServices = $vatRates;
	}

	public function render(): void
	{
		$this->template->render($this->getTemplateFile());
	}

	protected function createComponentForm(): BaseForm
	{
		$form = $this->createForm();
		$form->setAjax();

		$form->addText('name', 'eshopCatalog.vatRateForm.name')->setRequired()->setMaxLength(255);
		$form->addInteger('rate', 'eshopCatalog.vatRateForm.rate')->setRequired();

		if (Config::load('vatRate.showPohodaField', false)) {
			$form->addSelect('pohodaRate', 'eshopCatalog.vatRate.pohodaRate', [
				''      => '',
				'high'  => 'eshopCatalog.vatRate.pohodaRates.high',
				'low'   => 'eshopCatalog.vatRate.pohodaRates.low',
				'third' => 'eshopCatalog.vatRate.pohodaRates.third',
				'none'  => 'eshopCatalog.vatRate.pohodaRates.none',
			]);
		}

		$form->addSaveCancelControl();

		$form->onSuccess[] = [$this, 'formSuccess'];

		return $form;
	}

	public function formSuccess(BaseForm $form, ArrayHash $values): bool
	{
		try {
			$vatRate = $this->id ? $this->vatRateServices->getReference($this->id) : new VatRate;

			$vatRate->name = $values->name;
			$vatRate->rate = $values->rate;

			if (Config::load('vatRate.showPohodaField', false)) {
				if ($values->pohodaRate && $values->pohodaRate !== '') {
					$vatRate->pohodaRate = $values->pohodaRate;
				} else {
					$vatRate->pohodaRate = null;
				}
			}

			$this->em->persist($vatRate);
			$this->em->flush();
			$form->addCustomData('vatRateId', $vatRate->getId());
			$this->presenter->flashMessageSuccess('default.saved');
		} catch (Exception $e) {
			$form->addError($e->getMessage());

			return false;
		}

		return true;
	}

	public function setVatRate(int $id): void
	{
		$this->id      = $id;
		$this->vatRate = $this->em->getRepository(VatRate::class)->find($id);

		if (!$this->vatRate) {
			throw new InvalidArgumentException;
		}

		$this['form']->setDefaults([
			'name'       => $this->vatRate->name,
			'rate'       => $this->vatRate->rate,
			'pohodaRate' => $this->vatRate->pohodaRate,
		]);
	}

}
