<?php declare(strict_types = 1);

namespace EshopCatalog\AdminModule\Model\Subscribers;

use Core\Model\Application\AppState;
use EshopCatalog\Model\Config;
use EshopCatalog\Model\PseudoWarehouse;
use EshopOrders\FrontModule\Model\Event\OrderEvent;
use EshopOrders\Model\Entities\Order;
use EshopOrders\Model\Entities\OrderItem;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

class OrderFormSubscriber implements EventSubscriberInterface
{
	protected PseudoWarehouse $pseudoWarehouse;

	public function __construct(PseudoWarehouse $pseudoWarehouse)
	{
		$this->pseudoWarehouse = $pseudoWarehouse;
	}

	public static function getSubscribedEvents(): array
	{
		return [
			'eshopOrders.admin.correctiveTaxDocumentCreated' => ['correctiveTaxDocumentCreated', 100]
		];
	}

	public function correctiveTaxDocumentCreated(OrderEvent $event): void
	{
		if (!Config::load('pseudoWarehouse')) {
			return;
		}

		/** @var Order $order */
		$order = $event->order;
		$data = [];

		foreach ($order->getOrderItems()->toArray() as $item) {
			/** @var OrderItem $item */
			$data[$item->getProductId()] = $item->getQuantity();
		}

		AppState::setState('correctiveTaxDocumentFromOrder', $event->formData['fromOrder']);
		$this->pseudoWarehouse->raiseQuantities($data, $order);
	}

}