<?php declare(strict_types = 1);

namespace EshopCatalog\AdminModule\Model;

use Contributte\Translation\Translator;
use Core\Model\Helpers\BaseEntityService;
use Doctrine\ORM\Query\Expr\Join;
use EshopCatalog\Model\Entities\Tag;

/**
 * @method Tag getReference($id)
 * @method Tag[] getAll()
 * @method Tag|null get($id)
 */
class Tags extends BaseEntityService
{
	protected $entityClass = Tag::class;

	protected Translator $translator;
	protected ?array     $cOptionsForSelect = null;

	public function __construct(
		Translator $translator
	)
	{
		$this->translator = $translator;
	}

	public function getByType(string $type): ?Tag
	{
		return $this->getEr()->createQueryBuilder('t')->addSelect('tt')
			->leftJoin('t.texts', 'tt')
			->where('t.type = :type')->setParameter('type', $type)
			->getQuery()->getOneOrNullResult();
	}

	/**
	 * @return array<int, string>
	 */
	public function getOptionsForSelect(): array
	{
		if ($this->cOptionsForSelect === null) {
			$this->cOptionsForSelect = [];

			foreach ($this->getEr()->createQueryBuilder('t')->select('t.id, t.type, tt.name')
				         ->leftJoin('t.texts', 'tt', Join::WITH, 'tt.lang = :lang')
				         ->setParameter('lang', $this->translator->getLocale())
				         ->getQuery()->getArrayResult() as $row) {
				$this->cOptionsForSelect[$row['id']] = trim($row['name'] . ' (' . $row['type'] . ')');
			}
		}

		return $this->cOptionsForSelect;
	}

}
