<?php declare(strict_types = 1);

namespace EshopCatalog\AdminModule\Presenters;

use Core\Model\Sites;
use EshopCatalog\AdminModule\Components\AdminTools\ExportNames\FromHeureka;
use EshopCatalog\AdminModule\Components\AdminTools\ExportNames\IFromHeurekaFactory;
use EshopCatalog\Model\Config;
use EshopOrders\AdminModule\Presenters\BasePresenter;
use Nette\Security\Passwords;

class AdminToolsPresenter extends BasePresenter
{
	protected Sites $sites;

	public array $adminToolsUrlFiles = [];

	public function __construct(
		Sites $sites
	)
	{
		$this->sites = $sites;
	}

	public function renderDefault(): void
	{
		$this->template->adminToolsUrlFiles = $this->adminToolsUrlFiles;
	}

	/*******************************************************************************************************************
	 * ==================================   Handle
	 */

	/*******************************************************************************************************************
	 * ==================================   Actions
	 */

	public function actionDefault(): void
	{
		if (!$this->getUser()->isAllowed('EshopCatalog:Admin:AdminTools', 'access')) {
			$this->error();
		}

		$this->setHeader('eshopCatalog.title.adminToolsCatalog', 'fa fa-tools');

		$password = new Passwords();
		$keys     = [];
		foreach ($this->sites->getSites() as $k => $site) {
			$domains = [];
			foreach ($site->getDomains() as $domain) {
				if (!$domain->getDomain()) {
					continue;
				}

				$domains[] = $domain->getDomain();
			}

			$keys[$site->getIdent()] = [
				'ident'   => $site->getIdent(),
				'domains' => $domains,
				'key'     => $password->hash(Config::load('cronUrlHash') . $site->getIdent()),
			];
		}

		$this->template->keys = $keys;
	}

	/*******************************************************************************************************************
	 * ==================================   Components
	 */

	protected function createComponentExportNamesFromHeureka(IFromHeurekaFactory $factory): FromHeureka
	{
		return $factory->create();
	}
}

