<?php declare(strict_types = 1);

namespace EshopCatalog\AdminModule\Presenters;

use EshopCatalog\AdminModule\Components\ProductReplenishPlanner\IProductReplenishmentPlanGridFactory;
use EshopCatalog\AdminModule\Components\ProductReplenishPlanner\ProductReplenishmentPlanGrid;

class ProductReplenishmentPresenter extends BasePresenter
{
	public function actionDefault(): void
	{
		$this->setHeader('eshopCatalog.title.productReplenishment', 'fas fa-boxes');
	}

	public function createComponentProductReplenishmentPlanGrid(IProductReplenishmentPlanGridFactory $factory): ProductReplenishmentPlanGrid
	{
		return $factory->create();
	}

}