<?php declare(strict_types = 1);

namespace EshopCatalog\Console;

use Core\Model\Entities\EntityManagerDecorator;
use Doctrine\ORM\Tools\Console\Command\SchemaTool\AbstractCommand;
use EshopCatalog\AdminModule\Model\ProductReplenishmentPlanner;
use EshopCatalog\Model\Config;
use Exception;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\Console\Style\SymfonyStyle;
use Tracy\Debugger;

class CalculateProductReplenishment extends AbstractCommand
{
	/** @var ProductReplenishmentPlanner @inject */
	public ProductReplenishmentPlanner $planner;

	/** @var EntityManagerDecorator @inject */
	public EntityManagerDecorator $em;

	protected function configure(): void
	{
		$this->setName('eshop-catalog:calculate-product-replenishment')
			 ->setDescription('Calculate product replenishment');
	}

	protected function executeSchemaCommand(InputInterface $input, OutputInterface $output, $schemaTool, array $metadatas, SymfonyStyle $ui)
	{
		if (!Config::load('productReplenishmentPlanner.enable')) {
			$output->writeLn('<error>[ERROR] - Not enabled</error>');

			return Command::FAILURE;
		}

		ini_set('memory_limit', '5G');
		set_time_limit(7000);
		$this->em->getConnection()->getConfiguration()->setSQLLogger();
		$output->writeln('Calculate product replenishment');

		try {
			Debugger::dispatch();

			$this->planner->runCalc();

			$this->em->clear();
			gc_collect_cycles();

			$output->writeLn('<info>[OK] - Calculated</info>');
		} catch (Exception $e) {
			Debugger::log($e);
			$output->writeln('<error>[ERROR] - ' . $e->getMessage() . '</error>');

			return Command::FAILURE;
		}

		return Command::SUCCESS;
	}
}