<?php declare(strict_types = 1);

namespace EshopCatalog\CronModule\Presenters;

use EshopCatalog\FrontModule\Model\Categories;
use Nette\Application\ForbiddenRequestException;

class CategoriesPresenter extends BasePresenter
{
	/** @var Categories @inject */
	public $categoriesService;

	public function actionCategories(): void
	{
		if (!$this->getUser()->isAllowed('Core:Admin', 'access')) {
			throw new ForbiddenRequestException;
		}

		$lang = $this->getParameter('lang', null);
		$data = [];
		foreach ($this->categoriesService->getAllRootIds() as $rootAlias => $rootId) {
			foreach ($this->categoriesService->getCategories($rootId, $lang) as $cat) {
				$tmp    = [$cat->name];
				$parent = $cat->getParent();

				while ($parent) {
					if ($rootAlias !== $parent->name) {
						$tmp[] = $parent->name;
					}
					$parent = $parent->getParent();
				}

				$data[] = [
					'id'   => (string) $cat->getId(),
					'name' => $rootAlias . ' > ' . implode(' > ', array_reverse($tmp)),
				];
			}
		}

		$this->sendJson($data);
	}

}