<?php declare(strict_types = 1);

namespace EshopCatalog\CronModule\Presenters;

use Core\Model\Entities\EntityManagerDecorator;
use Nette\Application\ForbiddenRequestException;

class FeaturesPresenter extends BasePresenter
{
	protected EntityManagerDecorator $em;

	public function __construct(
		EntityManagerDecorator $em
	)
	{
		$this->em = $em;
	}

	public function actionFeatureValue(): void
	{
		if (!$this->getUser()->isAllowed('Core:Admin', 'access')) {
			throw new ForbiddenRequestException;
		}

		$conn = $this->em->getConnection();
		$lang = $this->getParameter('lang', $this->translator->getLocale());

		$data = [];

		foreach ($conn->executeQuery("SELECT fv.id, fvt.name, ft.name as feature FROM eshop_catalog__feature_value fv
				INNER JOIN eshop_catalog__feature_value_texts fvt ON fvt.id = fv.id AND fvt.lang = ?
				INNER JOIN eshop_catalog__feature f ON f.id = fv.feature_id
				INNER JOIN eshop_catalog__feature_texts ft ON ft.id = f.id AND ft.lang = ?
				ORDER BY f.position ASC, fv.position ASC", [$lang, $lang])->iterateAssociative() as $row) {
			$data[] = [
				'id'   => $row['id'],
				'name' => $row['feature'] . ' > ' . $row['name'],
			];
		}

		$this->sendJson($data);
	}

}
