<?php declare(strict_types = 1);

namespace EshopCatalog\FrontModule\Components\Personalization;

use EshopCatalog\Model\Personalization\Personalization;
use EshopCatalog\Model\Personalization\PersonalizationAccessControl;

class PersooAdvicioSwitcher extends PersonalizationControl
{
	protected Personalization $personalization;
	protected PersonalizationAccessControl $personalizationAccessControl;

	public function __construct(
		Personalization $personalization,
		PersonalizationAccessControl $personalizationAccessControl
	)
	{
		$this->personalization = $personalization;
		$this->personalizationAccessControl = $personalizationAccessControl;
	}

	public function render(): void
	{
		$this->template->isTurnOn = $this->isTurnOn();
		$this->template->render($this->getTemplateFile());
	}

	public function handleSwitch(): void
	{
		$this->personalizationAccessControl->switchService();
		$this->redirect('this');
	}

	public function isAllowed(): bool
	{
		return $this->personalizationAccessControl->isSwitcherAllowed();
	}

	public function isTurnOn(): bool
	{
		return $this->personalizationAccessControl->isOn();
	}

}