<?php declare(strict_types = 1);

namespace EshopCatalog\FrontModule\Model\Dao;

use EshopCatalog\Model\Helpers\DocumentsHelper;

class Document
{
	protected int     $id;
	protected string  $name;
	protected string  $file;
	protected ?string $lang = null;

	public function __construct(
		int     $id,
		string  $name,
		string  $file,
		?string $lang = null
	)
	{
		$this->id   = $id;
		$this->name = $name;
		$this->file = $file;
		$this->lang = $lang;
	}

	public function isSecured(): bool { return DocumentsHelper::isSecured($this->file); }

	public function getFilePath(): string { return $this->isSecured() ? '#' : $this->file; }

	public function getId(): int { return $this->id; }

	public function getName(): string { return $this->name; }

	public function getLang(): ?string { return $this->lang; }

}