<?php declare(strict_types = 1);

namespace EshopCatalog\FrontModule\Model\Event;

use Symfony\Contracts\EventDispatcher\Event;

class FilterLinkEvent extends Event
{
	public array   $currentFilter;
	public array   $categories;
	public ?string $type   = null;
	public ?string $key    = null;
	public ?string $value  = null;
	public ?string $result = null;

	public function __construct(
		array   $currentFilter,
		array   $categories,
		?string $type = null,
		?string $key = null,
		?string $value = null
	)
	{
		$this->currentFilter = $currentFilter;
		$this->categories    = $categories;
		$this->type          = $type;
		$this->key           = $key;
		$this->value         = $value;
	}

}
