<?php declare(strict_types = 1);

namespace EshopCatalog\FrontModule\Model\Subscribers;

use EshopCatalog\Model\Personalization\Personalization;
use EshopOrders\FrontModule\Model\Event\OrderEvent;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

class OrderSubscriber implements EventSubscriberInterface
{
	protected Personalization $personalization;

	public function __construct(Personalization $personalization)
	{
		$this->personalization = $personalization;
	}

	public static function getSubscribedEvents(): array
	{
		return [
			'eshopOrders.orderOnSuccess'       => ['orderOnSuccess', 100],
			'eshopOrders.admin.orderOnSuccess' => ['orderOnSuccess', 100]
		];
	}

	public function orderOnSuccess(OrderEvent $event): void
	{
		$this->personalization->putOrder($event->order);
	}

}