<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Entities;

use Doctrine\ORM\Mapping as ORM;
use Nette\Utils\DateTime;

/**
 * @ORM\Entity
 * @ORM\Table(name="eshop_catalog__category_check_products_count")
 */
class CategoryCheckProductsCount
{
	/**
	 * @ORM\Id
	 * @ORM\Column(type="string", options={"unsigned": true}, nullable=false)
	 */
	public string $categoryId;

	/**
	 * @ORM\Column(type="string", options={"unsigned": true}, nullable=true)
	 */
	public ?string $siteIdent = null;

	/**
	 * @ORM\Column(type="datetime", nullable=false, options={"default": "CURRENT_TIMESTAMP"})
	 */
	public ?\DateTimeInterface $created;

	public function __construct(string $categoryId)
	{
		$this->categoryId = $categoryId;
		$this->created    = new DateTime();
	}
}
