<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Entities;

use Doctrine;
use Doctrine\ORM\Mapping as ORM;
use EshopCatalog\FrontModule\Model\CacheService;
use EshopCatalog\Model\Helpers\VariantsHelper;
use Exception;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use Nette\SmartObject;

class CategoryProductListener implements EventSubscriberInterface
{
	use SmartObject;

	protected static array   $created = [];
	protected CacheService   $cacheService;
	protected VariantsHelper $variantsHelper;

	public function __construct(
		CacheService   $cacheService,
		VariantsHelper $variantsHelper
	)
	{
		$this->cacheService   = $cacheService;
		$this->variantsHelper = $variantsHelper;
	}

	public static function getSubscribedEvents(): array
	{
		return [];
	}

	/**
	 * @ORM\PreFlush
	 */
	public function onPreFlush(CategoryProduct $categoryProduct, Doctrine\ORM\Event\PreFlushEventArgs $args): void
	{
		$em = $args->getEntityManager();
		foreach ($em->getUnitOfWork()->getScheduledEntityInsertions() as $entity) {
			if ($entity instanceof CategoryProduct === false || $entity->getIdProduct() === null) {
				continue;
			}

			$key = $entity->getIdProduct() . '-' . $entity->getIdCategory();
			if (isset(self::$created[$key])) {
				continue;
			}
			self::$created[$key] = true;

			foreach ($this->variantsHelper->getVariantsOfProduct($entity->getIdProduct()) as $prodId) {
				try {
					$em->getConnection()->insert('eshop_catalog__category_product', [
						'id_product'  => $prodId,
						'id_category' => $entity->getIdCategory(),
					]);
				} catch (Exception $e) {
				}
			}
		}
	}

}
