<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Entities;

use Core\Model\Entities\TId;
use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Table(name="eshop_catalog__feature_category")
 * @ORM\Entity
 * @ORM\EntityListeners({"EshopCatalog\Model\Listeners\FeatureCategoryListener"})
 */
class FeatureCategory
{
	use TId;

	/**
	 * @ORM\ManyToOne(targetEntity="Category", inversedBy="features", cascade={"persist"})
	 * @ORM\JoinColumn(name="id_category", referencedColumnName="id", onDelete="CASCADE")
	 */
	public ?Category $category = null;

	/**
	 * @ORM\ManyToOne(targetEntity="FeatureValue", cascade={"persist"})
	 * @ORM\JoinColumn(name="id_feature_value", referencedColumnName="id", onDelete="CASCADE")
	 */
	public ?FeatureValue $featureValue = null;

	public function __construct(
		Category     $category,
		FeatureValue $featureValue
	)
	{
		$this->category     = $category;
		$this->featureValue = $featureValue;
	}

	public function getFeature(): ?Feature
	{
		return $this->getFeatureValue() ? $this->getFeatureValue()->getFeature() : null;
	}

	public function getFeatureValue(): ?FeatureValue
	{
		return $this->featureValue;
	}
}
