<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Entities;

use Doctrine;
use Doctrine\ORM\Event\LifecycleEventArgs;
use Doctrine\ORM\Mapping as ORM;
use DynamicModule\Model\Entities\FeatureText;
use EshopCatalog\FrontModule\Model\CacheService;
use Nette\SmartObject;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

class FeatureListener implements EventSubscriberInterface
{
	use SmartObject;

	protected CacheService $cacheService;

	public function __construct(
		CacheService $cacheService
	)
	{
		$this->cacheService = $cacheService;
	}

	public static function getSubscribedEvents(): array
	{
		return [];
	}

	/**
	 * @ORM\PostUpdate
	 *
	 * @param Feature|FeatureText $entity
	 */
	public function onPostUpdate($entity, LifecycleEventArgs $event): void
	{
		if (!$event->getEntityManager()->getConnection()->isTransactionActive()) {
			$ids = [];

			if ($entity instanceof Feature && $entity->getId() !== null) {
				$ids[] = $entity->getId();
			}

			if ($entity instanceof FeatureText && $entity->feature->getId() !== null) {
				$ids[] = $entity->feature->getId();
			}

			$this->cacheService->clearFeatures($ids);
		}
	}
}
