<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Entities;

use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Table(name="eshop_catalog__manufacturer_texts")
 * @ORM\Entity
 * @ORM\EntityListeners({"ManufacturerListener"})
 */
class ManufacturerTexts
{
	/**
	 * @ORM\Id
	 * @ORM\ManyToOne(targetEntity="Manufacturer", inversedBy="texts", cascade={"persist", "remove"})
	 * @ORM\JoinColumn(name="id", referencedColumnName="id", onDelete="CASCADE")
	 */
	private Manufacturer $id;

	/**
	 * @ORM\Id
	 * @ORM\Column(type="string", length=2)
	 */
	private string $lang;

	/**
	 * @ORM\Column(type="text", nullable=true)
	 */
	public ?string $description = null;

	public function __construct(Manufacturer $id, string $lang)
	{
		$this->id   = $id;
		$this->lang = $lang;
	}

	public function getLang(): string
	{
		return $this->lang;
	}

	public function getManufacturer(): Manufacturer { return $this->id; }

}