<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Entities;

use Doctrine\ORM\Mapping as ORM;
use Nette\Utils\DateTime;

/**
 * @ORM\Table(name="eshop_catalog__product_tag", indexes={@ORM\Index(name="valid_idx", columns={"valid_from", "valid_to"})})
 * @ORM\Entity
 */
class ProductTag
{
	/**
	 * @ORM\Id
	 * @ORM\ManyToOne(targetEntity="Product", inversedBy="ProductTags", cascade={"persist"})
	 * @ORM\JoinColumn(name="id_product", referencedColumnName="id", onDelete="CASCADE")
	 */
	private Product $product;

	/**
	 * @ORM\Id
	 * @ORM\ManyToOne(targetEntity="Tag")
	 * @ORM\JoinColumn(name="id_tag", referencedColumnName="id", onDelete="CASCADE")
	 */
	private Tag $tag;

	/**
	 * @var DateTime|null
	 * @ORM\Column(type="datetime", nullable=true)
	 */
	public $validFrom;

	/**
	 * @var DateTime|null
	 * @ORM\Column(type="datetime", nullable=true)
	 */
	public $validTo;

	public function __construct(Product $product, Tag $tag)
	{
		$this->product = $product;
		$this->tag     = $tag;
	}

	public function setProduct(Product $product): self
	{
		$this->product = $product;

		return $this;
	}

	public function getProduct(): Product
	{
		return $this->product;
	}

	public function getTag(): Tag
	{
		return $this->tag;
	}

}